#!/bin/sh
set -e
for f in /tmp/*.deb
do
        echo "Processing $f file..."
        # use dpkg -I to retrieve package dependencies, do some cleanup with sed to isolate package names
        # remove 3djuump packages as they are not pulled from apt
        # dependency list might contain | that will cause issues while trying to pass it to apt install
        dpkg -I $f \
                | grep -Po "^\s*Depends:.*$" \
                | sed "s/Depends://g" \
                | sed "s/([^,]*)//g" \
                | sed "s/,//g" \
                | sed "s/\S*3djuump\S*//g" \
                | sed "s/|//g" \
                >> ./dependencies.txt
        echo " " >> dependencies.txt;
done
toinstall=$(tr -d '\n' < dependencies.txt)
apt --assume-yes install $toinstall